tailleraster1	EQU 26
tailleraster2	EQU 20

ORG &77BC

	DI		; Desactiver les interruptions
	LD HL,(&38) 	; Lire l'ancienne interruption
	LD (Sauver),HL 	; Sauvegarder la valeur 16 bits
	LD HL,&C9FB 	; Registre 16 bits EI (&FB) + RET (&C9)
	LD (&38),HL 	; Ecrire en &0038 et &0039 le contenu du registre HL
	EI 		; Interruption autorisees

.Programme
	;raster1b rotation vers le bas
	LD A,(Raster1b+tailleraster1-1)
	LD HL,Raster1b+tailleraster1-2
	LD DE,Raster1b+tailleraster1-1
	LD BC,tailleraster1-1
	LDDR
	LD (Raster1b),A
	;raster 2 rotation vers le haut
	LD A,(Raster2)
	LD HL,Raster2+1
	LD DE,Raster2
	LD BC,tailleraster2-1
	LDIR
	LD (Raster2+tailleraster2-1),A


	LD B,&F5 	; Se connecter au PPI/8255 port B accessible via &F5xx
.Balayage
	IN A,(C) 	; Lire le contenu
	RRA 		; On teste si le bit 0 = 1
	JP NC,Balayage 	; Si le bit 0 = 0 on boucle jusqu'a la fin du balayage
			; On est en haut de l'ecran, on peut continuer le programme

	HALT 		; Attendre interruption 1
	HALT 		; Attendre interruption 2

	DS 20 		; 20 nop - pour une position en debut de ligne

	LD B,&7F 	; On selection le Gate Array
	LD HL,Raster 	; HL pointe sur la table de couleurs
.BoucleRaster
	LD a,(hl) 	; On charge la couleur dans A
	CP &00 		; Si A=0 alors
	JP Z,Touche 	; Saut au test clavier

	LD C,16 	
	OUT (C),C	; Selection du border
	OUT (C),A 	; Ecrire la couleur

	LD C,2
	OUT (C),C 	; Selection encre 2
	OUT (C),A 	; Ecrire la couleur

	INC HL 		; Couleur suivante dans le tableau
	DS 32 		; On attend la fin de la ligne... (32 nops)
	JP BoucleRaster


; Test touche
.Touche
	LD BC,&F40E
	OUT (C),C	;[PIO A] PSG -> Select Reg14
	LD BC,&F6C0	;PPI I/O
	OUT (C),C
	XOR A
	OUT (C),A
	LD BC,&F792	;PPI I/O C Control
	OUT (C),C
	LD BC,&F645	;PPI I/O C - &45 = ligne 5
	OUT (C),C
	LD B,&F4	;PPI I/O A - lire ligne clavier
	IN A,(C)	
	LD BC,&F782	;PPI I/O C Control
	OUT (C),C
	LD BC,&F600	;PPI I/O C
	OUT (C),C
	RLA		;Rotation a gauche - bit 7 (touche ESPACE)
	RLA		;Rotation a gauche - bit 6 (touche N)
	JR NC,ToucheN	;Si la touche N est enfoncee on quit
	RLA		;Rotation a gauche - bit 5 (touche J)
	RLA		;Rotation a gauche - bit 4 (touche H)
	RLA		;Rotation a gauche - bit 3 (touche Y)
	JP C,Programme	;Si la touche Y n'est pas enfoncee on boucle

.ToucheY
	LD A,1
	LD (&BE80),A	;Ecrire 1 en &BE80
	CALL Restaurer
	RET

.ToucheN
	LD A,2
	LD (&BE80),A	;Ecrire 2 en &BE80
	CALL Restaurer
	RET

.Restaurer
	DI 		; Desactiver les interruptions
	LD HL,(Sauver) 	; Restauration des anciennes interruptions
	LD (&38),hl 	; Ecrire
	EI 		; Interruption autorisees
	RET		; Retour

.Sauver
	DW #0000	;Sauvegarde valeur 16 bits

.Raster
;&54 noir       &44 bleu          &55 bleu vif       &5C rouge fonce  &58 magenta      &5D mauve
;&4C rouge vif  &45 pourpre       &4D magenta vif    &56 vert         &46 turquoise    &57 bleu ciel
;&5E jaune      &40 gris          &5F bleu pastel    &4E orange       &47 rose         &4F magenta pastel
;&52 vert vif   &42 vert marin    &53 turquoise vif  &5A vert citron  &59 vert pastel  &5B turquoise pastel
;&4A jaune vif  &43 jaune pastel  &4B blanc

	DB &5F ;border bleu pastel

.Raster1
	;zone fixe
	DB &58 		;magenta
	DB &5F 		;bleu pastel
	DB &58,&58 	;magenta
	DB &5F 		;bleu pastel
	DB &58,&58,&58 	;magenta
	DB &4D,&4D 	;magenta vif
	DB &58 		;magenta
	DB &4D,&4D,&4D 	;magenta vif
	DB &4F 		;magenta pastel
	DB &4D,&4D 	;magenta vif
	DB &4F,&4F 	;magenta pastel

.Raster1b 
	DB &56 		;vert
	DB &5A,&5A,&5A 	;vert citron
	DB &56 		;vert
	DB &5A,&5A 	;vert citron
	DB &4A 		;jaune vif
	DB &43,&43 	;jaune pastel
	DB &42,&42 	;vert marin
	DB &4B 		;blanc

	 ;zone fixe
	DB &4B 		;blanc
	DB &42,&42 	;vert marin
	DB &43,&43 	;jaune pastel
	DB &4A 		;jaune vif
	DB &5A,&5A	;vert citron
	DB &56		;vert
	DB &5A,&5A,&5A 	;vert citron
	DB &56		;vert
	DB &4F,&4F 	;magenta pastel
	DB &4D,&4D 	;magenta vif
	DB &4F,&4F 	;magenta pastel
	DB &4D,&4D 	;magenta vif
	DB &4F 		;magenta pastel
	DB &4D,&4D,&4D 	;magenta vif
	DB &58 		;magenta
	DB &4D,&4D 	;magenta vif
	DB &58,&58,&58 	;magenta
	DB &5F 		;bleu pastel
	DB &58,&58 	;magenta
	DB &5F 		;bleu pastel
	DB &58 		;magenta


	DB &5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F
	DB &5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F
	DB &5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F
	DB &5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F
	DB &5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F
	DB &5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F
	DB &5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F
	DB &5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F,&5F

.Raster2
	DB &5C     	;rouge fonce
	DB &4C,&4C 	;rouge vif
	DB &4E,&4E 	;orange
	DB &4A,&4A 	;jaune vif
	DB &43,&43 	;jaune pastel
	DB &4B,&4B 	;blanc
	DB &43,&43 	;jaune pastel
	DB &4A,&4A 	;jaune vif
	DB &4E,&4E 	;orange
	DB &4C,&4C 	;rouge vif
	DB &5C     	;rouge fonce

	DB &5F		;border bleu pastel
	DB 0		;fin
